﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI.WebControls;
using Microsoft.Reporting.WebForms;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.Business.Utilities; 

public partial class controls_ReportParametersControl : BaseControl
{
    List<ReportParameter> _reportParameters = new List<ReportParameter>();

    public string ServerReportName { get; set; }
    public string ServerReportParameters { get; set; }
    public bool YearsSelection { get; set; }
    
    private bool _yearsDefinition = true;
    public bool YearsDefinition
    {
        get { return _yearsDefinition; }
        set { _yearsDefinition = value; }
    }

    private bool _visnsSelection = true;
    public bool VisnsSelection
    {
        get { return _visnsSelection; }
        set { _visnsSelection = value; }
    }

    private bool _referralId = false;
    public bool ShowReferralId
    {
        get { return _referralId; }
        set { _referralId = value; }
    }
    
    private bool _username = false;
    public bool UserNameFilter
    {
        get { return _username; }
        set { _username = value; }
    }

    private bool _dateFrom = false;
    public bool DateFrom
    {
        get { return _dateFrom; }
        set { _dateFrom = value; }
    }

    private bool _dateTo = false;
    public bool DateTo
    {
        get { return _dateTo; }
        set { _dateTo = value; }
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            //visns
            if (VisnsSelection)
            {
                GetVisnsListBox();
            }
            else
            {
                ListBoxVisns.Visible = false;
                LabelVisn.Visible = false;
                CellForListBoxVisns.Visible = false;
            }

           

            //Years Selection
            if (YearsSelection)
            {
                GetYearsListBox();
            }
            else
            {
                ListBoxYearSelection.Visible = false;
                LabelYearSelection.Visible = false;
                CellForListBoxYearSelection.Visible = false;
            }

            //Years Definition
            if (!YearsDefinition)
            {
                DropDownListYearDefinition.Visible = false;
                LabelYearDefinition.Visible = false;
                RequiredFieldValidatorDropDownListYearDefinition.Enabled = false;

                CellForDropDownListYearDefinition.Visible = false;

            }

            //Referral Id
            if (!ShowReferralId)
            {
                TextBoxReferralId.Visible = false;
                LabelReferralId.Visible = false;
                RangeValidatorTextBoxReferralId.Enabled = false;

                CellForTextBoxReferralId.Visible = false;

            }

            //Date From
            if (!DateFrom)
            {
                TextBoxDateFrom.Visible = false;
                LabelDateFrom.Visible = false;
                CompareValidatorTextBoxDateFrom.Enabled = false;

                CellForTextBoxDateFrom.Visible = false;

            }
            else
            { 
                CompareValidatorTextBoxDateFrom.ValueToCompare = DateTime.Now.ToShortDateString();
            }

            //Date To
            if (!DateTo)
            {
                TextBoxDateTo.Visible = false;
                LabelDateTo.Visible = false;
                CompareValidatorTextBoxDateTo.Enabled = false;

                CellForTextBoxDateTo.Visible = false;

            }
            else
            {
                CompareValidatorTextBoxDateTo.ValueToCompare = DateTime.Now.ToShortDateString();
            }

            //Username
            if (!UserNameFilter)
            {
                TextBoxUserName.Visible = false;
                LabelForTextBoxUserName.Visible = false;
                RequiredFieldValidatorUserName.Enabled = false;

                CellForTextBoxUserName.Visible = false;

            }

        }
    }
    protected void ButtonRunReportClick(object sender, EventArgs e)
    {
        ReportViewerReport.Reset();
        SetReportPath();
        SetReportParameters();

        ReportViewerReport.ProcessingMode = ProcessingMode.Remote;
        ReportViewerReport.Visible = true;
        ReportViewerReport.ServerReport.Refresh();
    }
   
    private void SetReportPath()
    {
        ReportViewerReport.ServerReport.ReportPath = ServerReportName;

        var config = RegistriesConfigurations.GetConfig();

        ReportViewerReport.ServerReport.ReportServerUrl = new Uri(Helpers.GetConfigEntry("ReportingServer"));
        //ReportViewerReport.ServerReport.ReportServerUrl = new Uri(config.ReportingServer);
                
        if (ReportViewerReport.ServerReport.ReportPath.IndexOf(
                Helpers.GetConfigEntry("BaseReportPath"), 0) == -1)
                //config.BaseReportPath, 0) == -1)
        {
            ReportViewerReport.ServerReport.ReportPath =
                Helpers.GetConfigEntry("BaseReportPath") + ReportViewerReport.ServerReport.ReportPath;
            //config.BaseReportPath + ReportViewerReport.ServerReport.ReportPath;
        }
    }
    private void SetReportParameters()
    {
        _reportParameters.Clear();

        SetUsername();
        SetUsernameFilter();
        SetReferralId();
        SetDateFrom();
        SetDateTo();
        SetVisns();
        SetYearsDefinition();
        SetYears();

        ReportViewerReport.ServerReport.SetParameters(_reportParameters);
    }
    private void SetDateTo()
    {
        if (DateTo && TextBoxDateTo.Text != "")
        {
            ReportParameter reportParamDateTo = new ReportParameter("toDate", TextBoxDateTo.Text);
            _reportParameters.Add(reportParamDateTo);

            ServerReportParameters += Environment.NewLine + " toDate: " + TextBoxDateTo.Text; 
            
        }
    }
    private void SetDateFrom()
    {
        if (DateFrom && TextBoxDateFrom.Text != "")
        {
            ReportParameter reportParamDateFrom = new ReportParameter("fromDate", TextBoxDateFrom.Text);
            _reportParameters.Add(reportParamDateFrom);

            ServerReportParameters += Environment.NewLine + " fromDate: " + TextBoxDateFrom.Text; 

        }
    }
    private void SetReferralId()
    {
        if (ShowReferralId && TextBoxReferralId.Text != "")
        {
            ReportParameter reportParamReferralId = new ReportParameter("referralId", TextBoxReferralId.Text);
            _reportParameters.Add(reportParamReferralId);

            ServerReportParameters += Environment.NewLine + " referralId: " + TextBoxReferralId.Text; 

        }
    }
    private void SetYears()
    {
        //years
        if (YearsSelection)
        {
            var selectedIndices = ListBoxYearSelection.GetSelectedIndices();
            var selectedYears = new List<string>();

            for (int i = 0; i < selectedIndices.Count(); i++)
            {
                selectedYears.Add(ListBoxYearSelection.Items[selectedIndices[i]].Text);
            }

            ReportParameter reportParamYears = new ReportParameter("RptYrSel", selectedYears.ToArray());
            _reportParameters.Add(reportParamYears);

            ServerReportParameters += Environment.NewLine + " Years Selected: " + String.Join(", ", selectedYears.ToArray());

        }

        //Test years: 
        //ReportParameter reportParamYears = new ReportParameter("RptYrSel", "2010");
        //_reportParameters.Add(reportParamYears);
    }
    private void SetVisns()
    {
        if (VisnsSelection)
        {
            var selectedVisnsIndices = ListBoxVisns.GetSelectedIndices();
            var selectedVisns = new List<string>();

            foreach (var index in selectedVisnsIndices)
            {
                if (ListBoxVisns.Items[index].Text.Length == 6)
                {
                    selectedVisns.Add(ListBoxVisns.Items[index].Text.Substring(0, 1)
                                      + "0"
                                      + ListBoxVisns.Items[index].Text.Substring(5, ListBoxVisns.Items[index].Text.Length - 5));
                }
                else
                {
                    selectedVisns.Add(ListBoxVisns.Items[index].Text.Substring(0, 1)
                                      + ListBoxVisns.Items[index].Text.Substring(5, ListBoxVisns.Items[index].Text.Length - 5));
                }
            }

            ReportParameter reportParamVisns = new ReportParameter("VisnID", selectedVisns.ToArray());
            _reportParameters.Add(reportParamVisns);

            //Test visns: 
            //ReportParameter reportParamVisns = new ReportParameter("VisnID", "V23");
            //_reportParameters.Add(reportParamVisns);

            ServerReportParameters += Environment.NewLine + " VISN's Selected: " + String.Join(", ", selectedVisns.ToArray());

        }
    }
    private void SetYearsDefinition()
    {
        if (YearsDefinition)
        {
            ReportParameter reportParamYearDefinition =
                new ReportParameter("RptYrDef", DropDownListYearDefinition.SelectedItem.Text);
            _reportParameters.Add(reportParamYearDefinition);

            //Test year definition: 
            //ReportParameter reportParamYearDefinition = new ReportParameter("RptYrDef", "Fiscal Year");
            //_reportParameters.Add(reportParamYearDefinition);

            ServerReportParameters += Environment.NewLine + " Year Type: " + DropDownListYearDefinition.SelectedItem.Text;
        }
    }
    private void SetUsernameFilter()
    {
        if (UserNameFilter)
        {
            //username
            ReportParameter reportParamUsername = new ReportParameter("UsernameFilter", TextBoxUserName.Text);
            _reportParameters.Add(reportParamUsername);

            //Test user: 
            //ReportParameter reportParamUsername = new ReportParameter("Username", "aboros99");
            //_reportParameters.Add(reportParamUsername);

            ServerReportParameters += Environment.NewLine + " Username Filter: " + TextBoxUserName.Text;

        }
    }
    private void SetUsername()
    {
        //user
        UserAccountManager _currentUser = (UserAccountManager)HttpContext.Current.User;
        ReportParameter reportParamUsername = new ReportParameter("Username", _currentUser.Identity.Name);
        _reportParameters.Add(reportParamUsername);

        //Test user: 
        //ReportParameter reportParamUsername = new ReportParameter("Username", "aboros99");
        //_reportParameters.Add(reportParamUsername);
    }
    private void GetYearsListBox()
    {
        for (int i = DateTime.Now.Year + 1; i >= 2000; i--)
        {
            ListBoxYearSelection.Items.Add(new ListItem(i.ToString()));
        }

        for (int i = 0; i < ListBoxYearSelection.Items.Count; i++)
        {
            ListBoxYearSelection.Items[i].Selected = true;
        }
    }
    private void GetVisnsListBox()
    {
        ListBoxVisns.DataSource = ObjectDataSourceRegistryVISNs;
        ListBoxVisns.DataBind();

        for (int i = 0; i < ListBoxVisns.Items.Count; i++)
        {
            ListBoxVisns.Items[i].Selected = true;
        }
    }
    
}
